using System;
using System.Collections.Generic;
using System.Linq;

namespace Petlja
{
    internal class Program
    {
        static void Main()
        {
            int n = int.Parse(Console.ReadLine() ?? "0");
            List<(int x, int y)> points = new List<(int x, int y)>();

            for (int i = 0; i < n; i++)
            {
                string[] input = Console.ReadLine()?.Split(' ') ?? [];
                points.Add((int.Parse(input[0]), int.Parse(input[1])));
            }

            int count = points.Count;
            long smallestArea = long.MaxValue;

            for (int i = 0; i < n; i++)
            {
                List<(int x, int y)> reducedPoints = points.Where((_, idx) => idx != i).ToList();
                reducedPoints = reducedPoints.OrderBy(p => p.x).ThenBy(p => p.y).ToList();
                List<(int x, int y)> lower = new List<(int x, int y)>();
                foreach ((int x, int y) p in reducedPoints)
                {
                    while (lower.Count >= 2 && (long)(lower[^1].x - lower[^2].x) * (p.y - lower[^2].y) - (long)(lower[^1].y - lower[^2].y) * (p.x - lower[^2].x) <= 0)
                        lower.RemoveAt(lower.Count - 1);
                    lower.Add(p);
                }

                List<(int x, int y)> upper = new List<(int x, int y)>();
                foreach ((int x, int y) p in reducedPoints.AsEnumerable().Reverse())
                {
                    while (upper.Count >= 2 && (long)(upper[^1].x - upper[^2].x) * (p.y - upper[^2].y) - (long)(upper[^1].y - upper[^2].y) * (p.x - upper[^2].x) <= 0)
                        upper.RemoveAt(upper.Count - 1);
                    upper.Add(p);
                }

                lower.RemoveAt(lower.Count - 1);
                upper.RemoveAt(upper.Count - 1);
                lower.AddRange(upper);

                List<(int x, int y)> hull = lower;
                long area = 0;
                int hullSize = hull.Count;

                for (int j = 0; j < hullSize; j++)
                {
                    var p1 = hull[j];
                    var p2 = hull[(j + 1) % hullSize];
                    area += (long)p1.x * p2.y - (long)p1.y * p2.x;
                }

                smallestArea = Math.Min(smallestArea, Math.Abs(area) / 2);
            }

            Console.WriteLine(smallestArea);
        }
    }
}